<?php

namespace App\Http\Controllers;

use App\Models\Kategori;
use App\Models\Member;
use App\Models\Pembelian;
use App\Models\Pengeluaran;
use App\Models\Penjualan;
use App\Models\PenjualanDetail;
use App\Models\TotalKeseluruhan;
use App\Models\Produk;
use App\Models\Personal;
use App\Models\Paket;
use App\Models\Paket_personal_trainer;
use App\Models\Supplier;
use App\Models\Instruktur;
use App\Models\Marketing;
use App\Models\Fee;
use App\Models\CheckMember;
use App\Models\Staff;
use App\Models\CheckIns;
use App\Models\Checkinpt;
use App\Models\User;
use App\Models\Hadir;
use Carbon\Carbon;
use DB;
use App\Models\PembelianGym;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
         $date = Carbon::now();
        // $t=Carbon::now()->format('Y/m/d H:i:s');
        // dd($t);
        $expired = Member::where('exp_date', '<', now()->addDays(4))->count();
        $data_expired = Member::where('exp_date', '<', now()->addDays(4))->get();
        // dd($expired);
        $marketing = Paket::count();
        $member_all = Member::all();
        // dd($member_all);
        $paket_pt = Paket_personal_trainer::count();
        $produk = Produk::count();
        $supplier = Instruktur::count();
        $personal = Personal::count();
        $member = Member::count();
        $jumlah_laki = Member::where('gender','L')->count();
        $jumlah_perempuan = Member::where('gender','P')->count();
        $jumlah_aktif = Member::where('status','Aktif')->count();
        $jumlah_aktif2 = Member::where('status2','Aktif')->count();
        $jumlah_expired = Member::where('status','Expired')->count();
        $jumlah_expired2 = Member::where('status2','Expired')->count();
        $date = Carbon::now()->format('Y-m-d');
        $pengeluaran = PembelianGym::where('created_at', 'LIKE', "%$date%")->sum('total');
        // dd($pengeluaran);
       $penjualan_gym = Penjualan::where('created_at', 'LIKE', "%$date%")->sum('total_harga');
    //   $penjualan_member = Member::where('created_at', 'LIKE', "%$date%")->sum('total_harga');
    //   dd($penjualan_gym);
        $total_hadir = Hadir::where('tanggal', 'LIKE', "%$date%")->count('tanggal');
        $total_checkin_staff = Staff::where('created_at', 'LIKE', "%$date%")->count('name');
        $fee = Fee::where('created_at', 'LIKE', "%$date%")->sum('fee');
        $pengeluaran_hari_ini = $pengeluaran + $fee;
        $keseluruhan = TotalKeseluruhan::where('created_at', 'LIKE', "%$date%")->sum('total');
        $total_penjualan = PenjualanDetail::where('created_at', 'LIKE', "%$date%")->sum('subtotal');
        $total_member = TotalKeseluruhan::where('created_at', 'LIKE', "%$date%")->sum('total');
        // $total_pengeluaran = T::where('created_at', 'LIKE', "%$date%")->sum('total');
        $total_today = $total_penjualan + $total_member;
        // dd($total_today);
        $pemasukan_hari_ini = $total_penjualan + $keseluruhan;
        // dd($pemasukan_hari_ini);
        $tanggal_awal = date('Y-m-01');
        $tanggal_akhir = date('Y-m-d');
        $tanggal_sekarang = date('Y-m-01');
        $tanggal_terakhir = Carbon::now();
        // dd($tanggal_akhir);

        $data_tanggal = array();
        $data_pendapatan = array();

        while (strtotime($tanggal_awal) <= strtotime($tanggal_akhir)) {
            $data_tanggal[] = (int) substr($tanggal_awal, 8, 2);
            
            $total_penjualan = Penjualan::where('created_at', 'LIKE', "%$tanggal_awal%")->sum('bayar');
            $total_pengeluaran = PembelianGym::where('created_at', 'LIKE', "%$tanggal_awal%")->sum('total');
            $total_keseluruhan = TotalKeseluruhan::where('created_at', 'LIKE', "%$tanggal_awal%")->sum('total');
            
            // $total_pengeluaran = Pengeluaran::where('created_at', 'LIKE', "%$tanggal_awal%")->sum('nominal');

            $pendapatan = $total_penjualan - $total_pengeluaran + $total_keseluruhan;
            $data_pendapatan[] += $pendapatan;

            $tanggal_awal = date('Y-m-d', strtotime("+1 day", strtotime($tanggal_awal)));
            
        }
        if (auth()->user()->level == 1) {
            return view('admin.dashboard', compact('total_hadir','total_today','tanggal_sekarang','tanggal_terakhir','member_all','personal','paket_pt','total_checkin_staff','jumlah_expired2','jumlah_aktif2','data_expired','expired','produk', 'supplier', 'member', 'tanggal_awal', 'tanggal_akhir', 'data_tanggal', 'data_pendapatan','marketing','jumlah_laki','jumlah_perempuan','jumlah_aktif','jumlah_expired','total_penjualan','pemasukan_hari_ini','pengeluaran','date'));
        } else {
            return view('kasir.dashboard',compact('total_hadir','member_all','personal','paket_pt','jumlah_expired2','jumlah_aktif2','data_expired','expired','produk', 'supplier', 'member', 'tanggal_awal', 'tanggal_akhir', 'data_tanggal', 'data_pendapatan','marketing','jumlah_laki','jumlah_perempuan','jumlah_aktif','jumlah_expired','total_penjualan','pemasukan_hari_ini','pengeluaran'));
        }
    }
     public function show()
    {
        $data_expired = Member::where('exp_date', '<', now()->addDays(4))->get();

         return datatables()
            ->of($data_expired)
            ->addIndexColumn()
           
            ->addColumn('aksi', function ($data_expired) {
                return '
                <div class="btn-group">
                   <a href="'. route('member.edit', $data_expired->id_member) .'" class="btn btn-xs btn-info btn-flat">Perpanjangan</a>
                </div>

                 <div class="btn-group">
                    <a href="'. route('member.detail', $data_expired->id_member) .'" class="btn btn-xs btn-warning btn-flat">Detail</i></a>
                </div>
                ';
                
            })
            ->rawColumns(['aksi', 'kode_member'])
            ->make(true);
    }

    
    public function show3()
    {
        $data2 = Staff::all();
           

         return datatables()
            ->of($data2)
            ->addIndexColumn()
           
            
            ->rawColumns(['aksi',])
            ->make(true);
    }
     public function show4()
    {
        $from = Carbon::now()->subDays(7);
        $to = Carbon::now();
        $data = DB::table('checkinpt')
            ->join('personal_trainer', 'personal_trainer.id_personal', '=', 'checkinpt.id_personal')
            ->select('checkinpt.*', 'personal_trainer.nama_personal')
            ->where('checkinpt.waktu', '>=', $from)
            ->get();

         return datatables()
            ->of($data)
            ->addIndexColumn()      
            ->rawColumns(['aksi', 'id_personal'])
            ->make(true);
    }
}
