<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use\App\Models\Paket;
class PaketController extends Controller
{
     /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $kategori = Kategori::all()->pluck('nama_kategori', 'id_kategori');

        return view('paket.index');
    }

    public function data()
    {
        $paket = Paket::all();

        return datatables()
            ->of($paket)
            ->addIndexColumn()
            ->addColumn('select_all', function ($paket) {
                return '
                    <input type="checkbox" name="id[]" value="'. $paket->id .'">
                ';
            })
            ->addColumn('kode_paket', function ($paket) {
                return '<span class="label label-primary">'. $paket->kode_paket .'</span>';
            })
            ->addColumn('harga', function ($paket) {
                return 'Rp.'.format_uang($paket->harga);
            })
            ->addColumn('aksi', function ($paket) {
                return '
                <div class="btn-group">
                    <button type="button" onclick="editForm(`'. route('paket.update', $paket->id) .'`)" class="btn btn-xs btn-info btn-flat"><i class="fas fa-pencil-alt"></i></button>
                    <button type="button" onclick="deleteData(`'. route('paket.destroy', $paket->id) .'`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
                </div>
                ';
            })
            ->rawColumns(['aksi', 'kode_paket', 'select_all'])
            ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $harga = preg_replace('/[^0-9]/', '', $request->get('harga'));
        $paket_id = Paket::latest()->first() ?? new Paket();
        
        
        
        $paket = new Paket();
        $paket->kode_paket = 'PM'. tambah_nol_didepan((int)$paket_id->id +1,);
        $paket->nama_paket = $request->nama_paket;
        $paket->harga = $harga;
        $paket->save();

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $paket = Paket::find($id);

        return response()->json($paket);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $harga = preg_replace('/[^0-9]/', '', $request->get('harga'));
        $paket = Paket::find($id);
        $paket->nama_paket = $request->nama_paket;
        $paket->harga= $harga;
        $paket->update();

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $paket = Paket::find($id);
        $paket->delete();

        return response(null, 204);
    }

    public function deleteSelected(Request $request)
    {
        foreach ($request->id as $id) {
            $paket = Paket::find($id);
            $paket->delete();
        }

        return response(null, 204);
    }

    // public function cetakBarcode(Request $request)
    // {
    //     $dataproduk = array();
    //     foreach ($request->id_produk as $id) {
    //         $produk = Produk::find($id);
    //         $dataproduk[] = $produk;
    //     }

    //     $no  = 1;
    //     $pdf = PDF::loadView('produk.barcode', compact('dataproduk', 'no'));
    //     $pdf->setPaper('a4', 'potrait');
    //     return $pdf->stream('produk.pdf');
    // }
}
