<?php

namespace App\Http\Controllers;

use App\Models\Member;
use App\Models\Marketing;
use App\Models\Setting;
use App\Models\Penjualan;
use App\Models\Paket;
use App\Models\Absen;
use App\Models\Absen_personal;
use App\Models\Instruktur;
use App\Models\Paket_personal_trainer;
use App\Models\CheckMember;
use App\Models\Personal;
use App\Models\Staff;
use App\Models\Pegawai;
use App\Models\TotalKeseluruhan;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use Redirect,Response;
use Illuminate\Support\Facades\Validator;
use PDF;

class MemberController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       
         $null = Penjualan::where('kembali','<',0)->get();
        // dd($null);
        $marketing = Marketing::all()->pluck('nama_marketing', 'kode_marketing');
        $paket = Paket::all();
        $ins = Instruktur::all();
        $member = Member::all();
      
       
        // dd($today);
        return view('member.index', compact('marketing','paket','ins'));
    }

    public function data()
    {
       $null = NULL;
        $hari_ini = time();
        $member = Member::all();
        $today = Carbon::now()->format('d-m-Y');
        foreach ($member as $p => $prj) {
            if ($prj->status !== 'Cancel') {
                $tgl_masuk = strtotime($prj->tgl_masuk);
                $exp_date = strtotime($prj->exp_date);
                if ($hari_ini < $tgl_masuk && $hari_ini < $exp_date) {
                    Member::where('id_member',$prj->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status' => 'Aktif']);
                } else if ($hari_ini >= $tgl_masuk && $hari_ini <= $exp_date) {
                    Member::where('id_member',$prj->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status' => 'Aktif']);
                } else if ($hari_ini > $exp_date){
                    // if (!is_null($prj->garansi)) {
                    Member::where('id_member',$prj->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status' => 'Expired']);
                        
                     
                }                
            }              
        }
        foreach ($member as $p => $prj) {
            if ($prj->status2 !== 'Cancel') {
                $tgl_masuk2 = strtotime($prj->tgl_masuk2);
                $exp_date2 = strtotime($prj->exp_date2);
                if ($hari_ini < $tgl_masuk && $hari_ini < $exp_date2) {
                    Member::where('id_member',$prj->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status2' => 'Aktif']);
                } else if ($hari_ini >= $tgl_masuk2 && $hari_ini <= $exp_date2) {
                    Member::where('id_member',$prj->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status2' => 'Aktif']);
                } else if ($hari_ini > $exp_date2){
                    // if (!is_null($prj->garansi)) {
                    Member::where('id_member',$prj->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status2' => 'Expired']);
                        
                     
                }  else if ($tgl_masuk2 && $exp_date2 == NULL) {
                    // if (!is_null($prj->garansi)) {
                    Member::where('id_member',$prj->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status2' => 'pp']); 
                }              
            }
             
                          
        }

        $member =  Member::leftJoin('instruktur', 'instruktur.id_instruktur', 'member.id_instruktur')
        ->select('member.*', 'nama_instruktur')
        
        ->get();

            return datatables()
            ->of($member)
            ->addIndexColumn()
            ->addColumn('select_all', function ($member) {
                return '
                    <input type="checkbox" name="id_member[]" value="'. $member->id_member .'">
                ';
            })
            ->addColumn('kode_member', function ($member) {
                return '<span class="label label-primary">'. $member->kode_member .'<span>';
            })
            ->addColumn('status', function ($member) {
                if($member->status === 'Aktif')
                    return '<span class="label label-success">'. $member->status .'</span>';
                elseif($member->status === 'Expired')
                    return '<span class="label label-danger">'. $member->status .'</span>';
            })
             ->addColumn('status2', function ($member) {
                if($member->status2 === 'Aktif')
                    return '<span class="label label-success">'. $member->status2 .'</span>';
                elseif($member->status2 === 'Expired')
                    return '<span class="label label-danger">'. $member->status2 .'</span>';
            })
            //  <li><button type="button" onclick="showDetail10(`'. route('anu_paket.show', $member->id_member) .'`)" class="btn btn-xs btn-warning btn-flat"style="color:white; width: 158px; margin-top: -1px;">Detail Paket</button></li>
            ->addColumn('aksi', function ($member) {
                return '
               <div class="dropdown">
                    <button class="btn btn-info dropdown-toggle" type="button" data-toggle="dropdown">Opsi Member  <span class="caret"></span></button>
                    <ul class="dropdown-menu">
                        <li><a href="'. route('member.edit', $member->id_member) .'" class="btn btn-xs btn-info btn-flat" style="color:white;">Perpanjangan</a></li>
                        <li><a href="'. route('member.edit_profil', $member->id_member) .'" class="btn btn-xs btn-success btn-flat" style="color:white;">Edit Profil</a></li>
                        <li><a href="'. route('member.ganti_kartu', $member->id_member) .'" class="btn btn-xs btn-success btn-flat" style="color:white;">Ganti Kartu</a></li>
                        <li><a href="'. route('member.detail', $member->id_member) .'" class="btn btn-xs btn-warning btn-flat" style="color:white;">Detail</a></li>
                        <li><a href="'. route('member.cetak2', $member->id_member) .'" target="_blank" class="btn btn-xs btn-primary btn-flat" style="color:white;">Print</a></li>
                        <li><button type="button" onclick="deleteData(`'. route('member.destroy', $member->id_member) .'`)" class="btn btn-xs btn-danger btn-flat"style="color:white;width: 158px; margin-top: -1px;">Hapus</i></button></li>
                    </ul>
                </div>
                ';
            })
            ->rawColumns(['aksi', 'select_all', 'kode_member','nama_instruktur','status','status2'])
            ->make(true);
    }

    public function ambil_member_paket($id)
    {
         $detail = Member::where('id_member', $id)->get();

        return datatables()
            ->of($detail)
            ->addIndexColumn()
            ->addColumn('nama_paket', function ($detail) {
                return $detail->nama_paket;
            })
            ->rawColumns(['kode_produk'])
            ->make(true);
    }
    public function edit2($id)
    {
       
        // dd($staff2);
        $member = Member::find($id);
        $date = date('d-m-Y');
        $paket = Paket::orderBy('kode_paket', 'asc')->get();
        $paket_personal = Paket_personal_trainer::orderBy('kode_paket', 'asc')->get();
        $ins = Instruktur::all();
        $personal = Personal::all();
        return view('member.edit_profil', compact('paket','ins','date','paket_personal','personal','member'));
    }
     public function ganti_kartu($id)
    {
       
        // dd($staff2);
        $member = Member::find($id);
        $date = date('d-m-Y');
        $paket = Paket::orderBy('kode_paket', 'asc')->get();
        $paket_personal = Paket_personal_trainer::orderBy('kode_paket', 'asc')->get();
        $ins = Instruktur::all();
        $personal = Personal::all();
        return view('member.ganti_kartu', compact('paket','ins','date','paket_personal','personal','member'));
    }

   
    public function data_absen($id)
    {
      
        $member = CheckMember::where('kode_member',$id);
        return datatables()
            ->of($member)
            ->addIndexColumn()
            ->addColumn('select_all', function ($member) {
                return '
                   
                ';
            })
           
            ->addColumn('aksi', function ($member) {
                return '
               
                ';
            })
            ->rawColumns(['aksi', 'kode_paket', 'select_all'])
            ->make(true);
    }

    
    public function create()
    {
        $date = date('d-m-Y');
        $paket = Paket::orderBy('kode_paket', 'asc')->get();
        $paket_personal = Paket_personal_trainer::orderBy('kode_paket', 'asc')->get();
        $ins = Instruktur::all();
        $personal = Personal::all();
        $staff = Pegawai::all();

        return view('member.create',compact('staff','paket','ins','date','paket_personal','personal'));
    }
    public function layanan_ambilData(Request $request)
    {
        if(!$request->ajax()) abort(404);
        $hasil = [];
        $spl = json_decode($request->layanan_id);
        $layanan_id = Paket::where('nama_paket', $spl)->get();
        $hasil = $layanan_id;
        return Response::json($hasil);
        // dd($layanan_id);
    }
    public function layanan_ambilData2(Request $request)
    {
        if(!$request->ajax()) abort(404);
        $hasil = [];
        $spl = json_decode($request->iseng);
        $iseng = Paket_personal_trainer::where('nama_paket', $spl)->get();
        $hasil = $iseng;
        return Response::json($hasil);
        // dd($iseng);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
   

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store_absen2(Request $request)
    {
        $member = Absen_personal::latest()->first() ?? new Absen_personal();
       
        $member = Absen_personal::create($request->all());
       
// dd($member->all());
       return response()->json('Data berhasil disimpan', 200);
    }
    public function store(Request $request)
    {
        request()->validate([
           'kode_member' => 'required',
           'nama' => 'required',
           'ttl' => 'required',
           'alamat' => 'required',
           'telepon' => 'required',
           'telepon_darurat' => 'required',
           'no_ktp' => 'required',
           'gender' => 'required',
           'email' => 'required',
           'alamat_kantor' => 'required',
           'biaya_admin' => 'required',
           'biaya_lainnya' => 'required',
           'total' => 'required',
           'tanggal_bayar2' => 'required',
           'jenis_pembayaran_pribadi' => 'required',

        ],
        [
        'kode_member.required' => 'Kode member tidak boleh kosong',
         'nama.required' => 'Nama member tidak boleh kosong',
         'ttl.required' => 'Tempat tanggal lahir tidak boleh kosong',
         'alamat.required' => 'Alamat tidak boleh kosong',
         'telepon.required' => 'Telepon tidak boleh kosong',
         'telepon_darurat.required' => 'Telepon darurat tidak boleh kosong',
         'no_ktp.required' => 'Nomer KTP tidak boleh kosong',
         'gender.required' => 'Gender tidak boleh kosong',
         'email.required' => 'Email tidak boleh kosong',
         'alamat_kantor.required' => 'Alamat kantor tidak boleh kosong',
         'nama_paket.required' => 'Nama paket tidak boleh kosong',
         'harga.required' => 'Harga tidak boleh kosong',
         'tgl_masuk.required' => 'Tanggal masuk tidak boleh kosong',
         'exp_date.required' => 'Tanggal Expired  tidak boleh kosong',
         'nama_paket2.required' => 'Nama paket tidak boleh kosong',
         'harga2.required' => 'Harga tidak boleh kosong',
         'id_instruktur.required' => 'Personal trainer tidak boleh kosong',
         'tgl_masuk2.required' => 'Tanggal masuk tidak boleh kosong',
         'exp_date2.required' => 'Tanggal Expired tidak boleh kosong',
         'biaya_admin.required' => 'Biaya admin tidak boleh kosong',
         'biaya_lainnya.required' => 'Biaya lainnya tidak boleh kosong',
         'total.required' => 'Total tidak boleh kosong',
         'tanggal_bayar2.required' => 'Tanggal Pembayaran tidak boleh kosong',
         'jenis_pembayaran_pribadi.required' => 'Jenis Pembayaran tidak boleh kosong',
        //  'harus_bayar.required' => 'Harus bayar tidak boleh kosong',
        //  'sisa.required' => 'Sisa tidak boleh kosong',
        //  'nama_staff.required' => 'Nama Staff tidak boleh kosong',
        ]);
       
         
        $member_id = Member::latest()->first() ?? new Member();
        // $request['kode_member'] = 'M'. tambah_nol_didepan((int)$member_id->id_member+1,);
        $member = Member::create($request->all());
        
        $total =  new TotalKeseluruhan();
        $total->id_member = $member->id_member;
        $total->total = $request->total;
        $total->role = $request->role;
        $total->tgl_masuk = $request->tgl_masuk;
        $total->status = $request->status;
        // $total->harus_bayar = $request->harus_bayar;
        // $total->sisa = $request->sisa;
        // $total->catatan_utang = $request->catatan_utang;
        $total->nama_staff =  auth()->user()->name;
        // $request['nomer_absen'] = 'P'. tambah_nol_didepan((int)$total->id_member+1, 6);
        $total->save();



        return redirect()->route('member.index')->with('tambah','Data Berhasil Ditambah');
    }
    public function store_absen(Request $request)
    {
        $member = Absen::latest()->first() ?? new Absen();
       
        $member = Absen::create($request->all());
       
// dd($member->all());
       return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $member = Member::find($id);
    
        return view('member.detail', compact('member'));
    }
    public function data_absen2($id)
    {
      
        $member = Absen_personal::where('id_member',$id);

        return datatables()
            ->of($member)
            ->addIndexColumn()
            ->addColumn('select_all', function ($member) {
                return '
                   
                ';
            })
           
            ->addColumn('aksi', function ($member) {
                return '
               
                ';
            })
            ->rawColumns(['aksi', 'kode_paket', 'select_all'])
            ->make(true);
    }
     public function absen($id)
    {
        $member = Member::find($id);
    //   dd($member);
        return view('member.absen', compact('member'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $member = Member::find($id);
        $date = date('d-m-Y');
        $paket = Paket::orderBy('kode_paket', 'asc')->get();
        $paket_personal = Paket_personal_trainer::orderBy('kode_paket', 'asc')->get();
        $ins = Instruktur::all();
        $personal = Personal::all();
        $staff = Pegawai::all();
        return view('member.edit', compact('staff','paket','ins','date','paket_personal','personal','member'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
         
        $member = Member::find($id);
       
        // $member->kode_member = $request->kode_member;
       
        $member->tgl_masuk = $request->tgl_masuk;
        $member->tgl_masuk2 = $request->tgl_masuk2;
        $member->exp_date2 = $request->exp_date2;
        $member->status2 = $request->status2;
        $member->nama_paket = $request->nama_paket;
        $member->harga = $request->harga;
        $member->nama_paket2 = $request->nama_paket2;
        $member->harga2 = $request->harga2;
        $member->biaya_lainnya = $request->biaya_lainnya;
        $member->biaya_admin = $request->biaya_admin;
        $member->total_pembayaran = $request->total_pembayaran;
        $member->id_instruktur = $request->id_instruktur;
        $member->tanggal_bayar = $request->tanggal_bayar;
        $member->tanggal_bayar2 = $request->tanggal_bayar2;
        $member->jenis_pembayaran_member = $request->jenis_pembayaran_member;
        $member->jenis_pembayaran_pribadi = $request->jenis_pembayaran_pribadi;
        $member->exp_date = $request->exp_date;
        $member->status = $request->status;
        $member->role = $request->role;
        // $member->catatan = $request->catatan;
        $member->nama_staff = auth()->user()->name;
        // $request['nomer_absen'] = 'P'. tambah_nol_didepan((int)$member->id_member +1, 6);
        $member->update();
        
        $total =  new TotalKeseluruhan();
        $total->id_member = $request->id_member;
        $total->total = $request->total;
        $total->role = $request->role;
        $total->tgl_masuk = $request->tgl_masuk;
        $total->status = $request->status;
        // $total->harus_bayar = $request->harus_bayar;
        // $total->sisa = $request->sisa;
        // $total->catatan_utang = $request->catatan_utang;
        $total->nama_staff =  auth()->user()->name;
        // $request['nomer_absen'] = 'P'. tambah_nol_didepan((int)$total->id_member +1,);
        $total->save();

      return redirect()->route('member.index')->with('edit','Data Berhasil Perpanjang');
    }
    public function updated_detail(Request $request, $id)
    {
         
        $member = Member::find($id);
        $member->catatan = $request->catatan;
        $member->update();
        
      return redirect()->route('member.detail', $member->id_member)->with('edit','Data Berhasil Perpanjang');
    }
    public function updated_profil(Request $request, $id)
    {
        $member = Member::find($id);
       
        $member->kode_member = $request->kode_member;
        $member->nama = $request->nama;
        $member->ttl = $request->ttl;
        $member->no_ktp = $request->no_ktp;
        $member->gender = $request->gender;
        $member->alamat = $request->alamat;
        $member->alamat_kantor = $request->alamat_kantor;
        $member->sosmed = $request->sosmed;
        $member->telepon = $request->telepon;
        $member->telepon_darurat = $request->telepon_darurat;
        $member->email = $request->email;
        $member->update();

        $total =  new TotalKeseluruhan();
        $total->id_member = $request->id_member;
        $total->total = $request->total;
        $total->role = $request->role;
        $total->tgl_masuk = $request->tgl_masuk;
        $total->status = $request->status;
        // $total->harus_bayar = $request->harus_bayar;
        // $total->sisa = $request->sisa;
        // $total->catatan_utang = $request->catatan_utang;
        $total->nama_staff =  auth()->user()->name;
        // $request['nomer_absen'] = 'P'. tambah_nol_didepan((int)$total->id_member +1,);
        $total->save();
        return redirect()->route('member.index')->with('tambah','Data Berhasil Ditambah');
    }
     public function updated_kartu(Request $request, $id)
    {
        $member = Member::find($id);
       
        // $member->kode_member = $request->kode_member;
        $member->nama = $request->nama;
        $member->ttl = $request->ttl;
        $member->no_ktp = $request->no_ktp;
        $member->gender = $request->gender;
        $member->alamat = $request->alamat;
        $member->alamat_kantor = $request->alamat_kantor;
        $member->sosmed = $request->sosmed;
        $member->telepon = $request->telepon;
        $member->telepon_darurat = $request->telepon_darurat;
        $member->email = $request->email;
        $member->update();
        return redirect()->route('member.index')->with('tambah','Data Berhasil Ditambah');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $member = Member::find($id);
        $member->delete();

        return response(null, 204);
    }

    public function cetak2($id)
    {
          $member = Member::find($id);
        return view('member.cetak2', compact('member'));
    }
    public function cetakMember(Request $request)
    {
        $datamember = collect(array());
        foreach ($request->id_member as $id) {
            $member = Member::find($id);
            $datamember[] = $member;
        }

        $datamember = $datamember->chunk(2);
        $setting    = Setting::first();

        $no  = 1;
        $pdf = PDF::loadView('member.cetak', compact('datamember', 'no', 'setting'));
        $pdf->setPaper(array(0, 0, 566.93, 850.39), 'potrait');
        return $pdf->stream('member.pdf');
    }

     public function cetak_pdf($id)
    {
    	$member = Member::find($id);
        
    	$pdf = PDF::loadview('member.cetak2',['member'=>$member]);
    	return $pdf->download('laporan-member-pdf');
    }
}
